% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland_shared_counts.R
\name{SharedCounts}
\alias{SharedCounts}
\title{Combine groups of genes with similar counts by clustering and summing.}
\usage{
SharedCounts(C, n_clusters, n_cells = 100, subsample = TRUE)
}
\arguments{
\item{C}{countland object}

\item{n_clusters}{number of clusters}

\item{n_cells}{number of cells to sample for gene clustering}

\item{subsample}{if TRUE, use subsampled counts (default), otherwise use counts}
}
\value{
countland object with slots \code{shared_counts}, \code{sum_sharedcounts}, \code{sum_sharedcounts_all}
}
\description{
Combine groups of genes with similar counts by clustering and summing.
}
\examples{
gold_path <- system.file("testdata", package = "countland", mustWork = TRUE)
gold.data <- Seurat::Read10X(data.dir = gold_path)
C <- countland(gold.data)
C <- SharedCounts(C,n_clusters=10,subsample=FALSE)
}
