% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland.R
\docType{class}
\name{countland-class}
\alias{countland-class}
\title{An S4 class to represent a countland object}
\description{
An S4 class to represent a countland object
}
\section{Slots}{

\describe{
\item{\code{counts}}{A dgCMatrix with rows as cells, columns as genes.}

\item{\code{names_genes}}{A character vector of column names.}

\item{\code{names_cells}}{A character vector of row names.}

\item{\code{raw_counts}}{The count dgCMatrix as originally loaded.}

\item{\code{raw_names_genes}}{The gene name character vector as originally loaded.}

\item{\code{raw_names_cells}}{The cell name character vector as originally loaded.}

\item{\code{subsample}}{A dgCMatrix with row sums equal.}

\item{\code{cell_scores}}{A data.frame of cell count measures.}

\item{\code{gene_scores}}{A data.frame of gene expression measures.}

\item{\code{dots}}{A similarity dgCMatrix of dot products.}

\item{\code{eigenvals}}{An vector of eigenvalues from spectral embedding}

\item{\code{embedding}}{An array of two columns (spectral embeddings).}

\item{\code{cluster_labels}}{A numeric vector of cluster assignments of length n cells.}

\item{\code{marker_full}}{A list of data.frames with genes ranked for each cluster.}

\item{\code{marker_genes}}{A data.frame of top ten marker genes per cluster.}

\item{\code{matrixU}}{A dgCMatrix of dimensions cells x features.}

\item{\code{matrixV}}{A dgCMatrix of dimensions genes x features.}

\item{\code{matrixLambda}}{A diagonal dgCMatrix of scaling factors.}

\item{\code{sharedcounts}}{A similarity dgCMatrix of shared counts between genes.}

\item{\code{sum_sharedcounts}}{A dgCMatrix with counts summed within gene clusters.}

\item{\code{sum_sharedcounts_all}}{A dgCMatrix with counts summed and including all genes not present in any cluster.}

\item{\code{norm_factor}}{A numeric vector of cell normalization factors.}

\item{\code{norm_counts}}{A dgCMatrix of normalized counts.}

\item{\code{log_counts}}{A dgCMatrix of log transformed counts.}

\item{\code{scaled_counts}}{A dgCMatrix of counts scaled by gene unit variance.}

\item{\code{centered_counts}}{A dgCMatrix of counts centered at zero.}

\item{\code{verbose}}{A T/F object for suppressing messages}
}}

