% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{ggdraw}
\alias{ggdraw}
\title{Set up a drawing layer on top of a ggplot}
\usage{
ggdraw(plot = NULL, xlim = c(0, 1), ylim = c(0, 1))
}
\arguments{
\item{plot}{The plot to use as a starting point. Can be a ggplot2 plot, an arbitrary gtable,
or a recorded base-R plot, as in \code{\link[=plot_grid]{plot_grid()}}.}

\item{xlim}{The x-axis limits for the drawing layer.}

\item{ylim}{The y-axis limits for the drawing layer.}
}
\description{
Set up a drawing layer on top of a ggplot
}
\examples{
p <- ggplot(mpg, aes(displ, cty)) + geom_point()
ggdraw(p) + draw_label("Draft", colour = "grey", size = 120, angle = 45)
}
