% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/say.R
\name{say}
\alias{say}
\alias{think}
\title{Sling messages and warnings with flair}
\usage{
say(
  what = "Hello world!",
  by = "cow",
  type = NULL,
  what_color = NULL,
  by_color = what_color,
  length = 18,
  fortune = NULL,
  width = 60,
  ...
)

think(
  what = "Hello world!",
  by = "cow",
  type = NULL,
  what_color = NULL,
  by_color = what_color,
  length = 18,
  fortune = NULL,
  width = 60,
  ...
)
}
\arguments{
\item{what}{(character) What do you want to say? See Details.}

\item{by}{(character) Who should say or think it? One of: alligator, ant,
anxiouscat, bat, bat2, beavis, behindcat, bigcat, blowfish, buffalo, cat,
chicken, chuck, clippy, cow, cow_borg, cow_dead, cow_greedy, cow_sleepy,
cow_tired, cow_wired, cow_young, daemon, dragon, duck, duckling, egret,
endlesshorse, facecat, fish, frog, ghost, goldfish, grumpycat, hypnotoad,
longcat, longtailcat, monkey, mushroom, owl, pig, poop, pumpkin, rabbit,
rms, shark, shortcat, signbunny, smallcat, snowman, spider, squirrel,
squirrel2, stegosaurus, stretchycat, trilobite, turkey, whale, wolf, yoda.
Alternatively, use 'random' to have your message spoken by a random
character.  We use \code{\link[rlang:arg_match]{rlang::arg_match()}} internally, which does not support
partial matching, so you'll get an informative error upon a partial match.}

\item{type}{(character) One of message (default), warning, print (default
in non-interactive mode), or string (returns string). If run in
non-interactive mode default type is print, so that
output goes to stdout rather than stderr, where messages and warnings go.}

\item{what_color}{(character or crayon function) One or more
\href{https://github.com/r-lib/crayon#256-colors}{\code{crayon}}-suported
text color(s) or
\href{https://github.com/r-lib/crayon#styles}{\code{crayon style function}}
to color \code{what}. You might try \code{colors()} or \code{?rgb} for ideas.
Use "rainbow" for c("red", "orange", "yellow", "green", "blue", "purple").}

\item{by_color}{(character or crayon function) One or more
\href{https://github.com/r-lib/crayon#256-colors}{\code{crayon}}-suported
text color(s) or
\href{https://github.com/r-lib/crayon#styles}{\code{crayon style function}}
to color \code{who}. Use "rainbow" for
\code{c("red", "orange", "yellow", "green", "blue", "purple")}. By default is
set to be whatever color \code{what_color} is so you can have the same color
for both with less typing.}

\item{length}{(integer) Length of longcat. Ignored if other animals used.}

\item{fortune}{An integer (or number that can be coerced
to integer) specifying a fortune from the \code{fortunes} package - OR a
string which is used as a pattern passed to \code{\link[=grep]{grep()}} (and a random one is
selected upton multiple matches). Passed on to the \code{which} parameter of
\code{fortunes::fortune}}

\item{width}{(integer/numeric) width of each line. default: 60}

\item{...}{Further args passed on to \code{fortunes::fortune()}}
}
\description{
Sling messages and warnings with flair
}
\section{what}{

You can put in any phrase you like to the \code{what} parameter, OR you
can type in one of a few special phrases that do particular things.
They are:
\itemize{
\item "catfact": A random cat fact from https://catfact.ninja
\item "fortune": A random quote from an R coder, from fortunes library
\item "time": Print the current time
\item "rms": Prints a random 'fact' about Richard Stallman from the
\code{\link[rmsfact:rmsfact]{rmsfact::rmsfact()}} package. Best paired with \code{by = "rms"}.
}
}

\section{by}{

Note that if you choose \code{by='hypnotoad'} the quote is forced to be,
as you could imagine, 'All Glory to the HYPNO TOAD!'. For reference see
http://knowyourmeme.com/memes/hypnotoad

signbunny: It's not for sure known who invented signbunny, but this article
http://www.vox.com/2014/9/18/6331753/sign-bunny-meme-explained thinks
they found the first use in this tweet:
https://twitter.com/wei_bluebear/status/329101645780770817

trilobite: from http://www.retrojunkie.com/asciiart/animals/dinos.htm (site
down though)

Note to Windows users: there are some animals (shortcat, longcat, fish,
signbunny, stretchycat, anxiouscat, longtailcat, grumpycat, mushroom) that
are not available because they use non-ASCII characters that don't display
properly in R on Windows.
}

\examples{
say()
say("what")
say("time")

say("who you callin chicken", "chicken")
say("ain't that some shit", "poop")
say("icanhazpdf?", "cat")
say("boo!", "pumpkin")
say("hot diggity", "frog")

# Vary type of output, default calls message()
say("hell no!")
say("hell no!", type = "warning")
say("hell no!", type = "string")

# The hypnotoad
say(by = "hypnotoad")

# Trilobite
say(by = "trilobite")

# Shark
say("Q: What do you call a solitary shark\nA: A lone shark", by = "shark")

# Buffalo
say("Q: What do you call a single buffalo?\nA: A buffalonely", by = "buffalo")

\dontshow{if (rlang::is_installed("fortunes")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Using fortunes
library(fortunes)
say(what = "fortune")
## you don't have to pass anything to the `what` parameter if `fortune` is
## not null
say("fortune", "spider")
say("fortune", "facecat")
say("fortune", "behindcat")
say("fortune", "smallcat")
say("fortune", "monkey")
say("fortune", "egret")
say(fortune = 10)
say(fortune = 100)
say(fortune = "whatever")
say(fortune = 7)
say(fortune = 45)
# Clippy
say(fortune = 59, by = "clippy")
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_installed("rmsfact")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(rmsfact)
say("rms", "rms")
\dontshow{\}) # examplesIf}
\dontshow{if (rlang::is_installed("jsonlite")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Using the catfacts API
library(jsonlite)
say("catfact", "cat")
\dontshow{\}) # examplesIf}
}
