% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mv.R
\name{PELT.MV}
\alias{PELT.MV}
\title{Most recent changepoints from MV method.}
\usage{
PELT.MV(data, beta = 101 * log(dim(data)[2]))
}
\arguments{
\item{data}{a censored data matrix.}

\item{beta}{default 101*log(dim(data)[2])). Here dim(data)[2] means consider
size(length) of series (n).}
}
\value{
indicates the most recent changepoint in each series .
}
\description{
Detecting most recent changepoints from MV methd (Lavielle and Teyssiere, 2006) deal with
multivariate data which is modeling the data within each segment as a
 multivariate (MV) Gaussian having a given covariance.
}
\examples{
# example
library(cpcens)
data("censoredex")
data=censoredex
N=100
n=144
pmv = PELT.MV( data , 101*log(dim(data)[2]) )
mv.chpts =  rep( rev( pmv$cpts )[1] , N )
}
