% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_multi_paths.R
\name{get_multi_paths}
\alias{get_multi_paths}
\title{Compute all shortest paths between origin and destination nodes.}
\usage{
get_multi_paths(Graph, from, to, keep = NULL, long = FALSE)
}
\arguments{
\item{Graph}{An object generated by \link{makegraph} or \link{cpp_simplify} function.}

\item{from}{A vector of one or more vertices from which shortest paths are calculated (origin).}

\item{to}{A vector of one or more vertices (destination).}

\item{keep}{numeric or character. Vertices of interest that will be returned.}

\item{long}{logical. If \code{TRUE}, a long data.frame is returned instead of a list.}
}
\value{
List or a data.frame containing shortest paths.
}
\description{
Compute all shortest paths between origin and destination nodes.
}
\details{
\code{get_multi_paths()} recursively perform Dijkstra algorithm for each 'from' nodes. It is the equivalent of \link{get_distance_matrix}, but it return the shortest path node sequence instead of the distance.

This algorithm is \strong{multithreaded.} Please use \code{RcppParallel::setThreadOptions()} to set the number of threads.
}
\note{
Be aware that if 'from' and 'to' have consequent size, output will require much memory space.
}
\examples{
#Choose number of cores used by cppRouting
RcppParallel::setThreadOptions(numThreads = 1)

#Data describing edges of the graph
edges<-data.frame(from_vertex=c(0,0,1,1,2,2,3,4,4),
                  to_vertex=c(1,3,2,4,4,5,1,3,5),
                  cost=c(9,2,11,3,5,12,4,1,6))

#Get all nodes
nodes<-unique(c(edges$from_vertex,edges$to_vertex))

#Construct directed graph
directed_graph<-makegraph(edges,directed=TRUE)

#Get all shortest paths (node sequences) between all nodes
dir_paths<-get_multi_paths(Graph=directed_graph, from=nodes, to=nodes)
print(dir_paths)

#Get the same result in data.frame format
dir_paths_df<-get_multi_paths(Graph=directed_graph, from=nodes, to=nodes, long = TRUE)
print(dir_paths_df)
}
\seealso{
\link{get_path_pair}, \link{get_isochrone}, \link{get_detour}
}
