% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta.R
\name{theta}
\alias{theta}
\title{Extract Regression Coefficients for B-Splines and Tensor Products of B-splines}
\usage{
theta(fit)
}
\arguments{
\item{fit}{a regression model fit}
}
\value{
the regression coefficients associated with terms with names
containing either "bsplines" or "btensor".
}
\description{
An S3 method for extracting the regression coefficients of the
\code{bsplines} and \code{btensor} terms.  By Default this uses
\code{stats::coef} to extract all the regression coefficients.  A specific
method for \code{lmerMod} objects has been provided.  If you are using a
regression method which \code{stats::coef} will not return the regression
coefficients, you'll need to define an S3 method for \code{stats::coef} to do
so.
}
\details{
This function is implicitly called in the \code{cpr::cp} and
\code{cpr::cn} calls.
}
\seealso{
\code{\link[stats]{coef}} \code{\link{cp}} \code{\link{cn}}
}
