% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cpr_summary_cpr_cpr.R
\name{plot.cpr_summary_cpr_cpr}
\alias{plot.cpr_summary_cpr_cpr}
\title{Plotting Summaries of Control Polygon Reductions}
\usage{
\method{plot}{cpr_summary_cpr_cpr}(
  x,
  type = c("rse", "rss", "loglik", "wiggle", "fdsc", "Pr(>w_(1))"),
  from = 1,
  to,
  ...
)
}
\arguments{
\item{x}{a \code{cpr_summary_cpr_cpr} object}

\item{type}{response to plot by index}

\item{from}{the first index of \code{x} to plot}

\item{to}{the last index of \code{x} to plot}

\item{...}{pass through}
}
\value{
a \code{ggplot} object
}
\description{
Plotting Summaries of Control Polygon Reductions
}
\examples{
set.seed(42)
x <- seq(0 + 1/5000, 6 - 1/5000, length.out = 100)
bmat <- bsplines(x, iknots = c(1, 1.5, 2.3, 4, 4.5), bknots = c(0, 6))
theta <- matrix(c(1, 0, 3.5, 4.2, 3.7, -0.5, -0.7, 2, 1.5), ncol = 1)
DF <- data.frame(x = x, truth = as.numeric(bmat \%*\% theta))
DF$y <- as.numeric(bmat \%*\% theta + rnorm(nrow(bmat), sd = 0.3))

initial_cp0 <-
  cp(y ~ bsplines(x, iknots = c(1, 1.5, 2.3, 3.0, 4, 4.5), bknots = c(0, 6))
     , data = DF
     , keep_fit = TRUE # default is FALSE
  )
cpr0 <- cpr(initial_cp0)
s0   <- summary(cpr0)

plot(s0, type = "rse")
plot(s0, type = "rss")
plot(s0, type = "loglik")
plot(s0, type = "wiggle")
plot(s0, type = "fdsc")
plot(s0, type = "Pr(>w_(1))")

}
\seealso{
\code{\link{plot.cpr_cpr}}, \code{\link{cpr}}
\code{\link{summary.cpr_cpr}}
}
