% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary.R
\name{plot.summary_cranly_network}
\alias{plot.summary_cranly_network}
\title{Top-n package or author barplots according to a range of network statistics}
\usage{
\method{plot}{summary_cranly_network}(x, top = 20, according_to = NULL,
  scale = FALSE, ...)
}
\arguments{
\item{x}{a \code{\link{summary_cranly_network}} object}

\item{top}{integer. How may top packages or authors should be plotted? Default is \code{20}}

\item{according_to}{the statistic according to which the top-\code{top} list is produced. See \code{\link{summary.cranly_network}} for available statistics}

\item{scale}{logical. Should the statistics be scaled to lie between \code{0} and \code{1} before plotting? Default is \code{FALSE}}

\item{...}{currently not used}
}
\description{
Top-n package or author barplots according to a range of network statistics
}
\examples{

\dontrun{
cran_db <- clean_CRAN_db()
## package network
package_network <- build_network(cran_db)
package_summaries <- summary(package_network)
plot(package_summaries, according_to = "n_imported_by", top = 30)
plot(package_summaries, according_to = "n_depended_by", top = 30)
plot(package_summaries, according_to = "page_rank", top = 30)

## author network
author_network <- build_network(cran_db, perspective = "author")
author_summaries <- summary(author_network)
plot(author_summaries, according_to = "n_collaborators", top = 30)
plot(author_summaries, according_to = "n_packages", top = 30)
plot(author_summaries, according_to = "page_rank", top = 30)
}

}
