% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_training.R
\name{lr_vif}
\alias{lr_vif}
\title{Variance-Inflation Factors}
\usage{
lr_vif(lr_model)
}
\arguments{
\item{lr_model}{An object of logistic model.}
}
\description{
\code{lr_vif} is  for calculating Variance-Inflation Factors.
}
\examples{
sub = cv_split(UCICreditCard, k = 30)[[1]]
x_list = c("PAY_0", "LIMIT_BAL", "PAY_AMT5", "PAY_3", "PAY_2")
dat = re_name(UCICreditCard[sub,], "default.payment.next.month", "target")
dat = dat[,c("target",x_list)]

dat = data_cleansing(dat, miss_values = list("", -1))

train_test <- train_test_split(dat,  prop = 0.7)
dat_train = train_test$train
dat_test = train_test$test

Formula = as.formula(paste("target", paste(x_list, collapse = ' + '), sep = ' ~ '))
set.seed(46)
lr_model = glm(Formula, data = dat_train[, c("target", x_list)], family = binomial(logit))
lr_vif(lr_model)
get_logistic_coef(lr_model)
class(dat)
mod = lr_model
lr_vif(lr_model)
}
