% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_transformation.R
\name{ranking_percent_proc}
\alias{ranking_percent_proc}
\alias{ranking_percent_proc_x}
\alias{ranking_percent_dict}
\alias{ranking_percent_dict_x}
\title{Ranking Percent Process}
\usage{
ranking_percent_proc(dat, ex_cols = NULL, x_list = NULL,
  rank_dict = NULL, pct = 0.01, parallel = FALSE, note = FALSE,
  save_data = FALSE, file_name = NULL, dir_path = tempdir(), ...)

ranking_percent_proc_x(dat, x, rank_dict = NULL, pct = 0.01)

ranking_percent_dict(dat, x_list = NULL, ex_cols = NULL, pct = 0.01,
  parallel = FALSE, save_data = FALSE, file_name = NULL,
  dir_path = tempdir(), ...)

ranking_percent_dict_x(dat, x = NULL, pct = 0.01)
}
\arguments{
\item{dat}{A data.frame.}

\item{ex_cols}{Names of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{x_list}{A list of x variables.}

\item{rank_dict}{The dictionary of rank_percent generated by \code{ranking_percent_dict} .}

\item{pct}{Percent of rank. Default is 0.01.}

\item{parallel}{Logical, parallel computing. Default is FALSE.}

\item{note}{Logical, outputs info. Default is TRUE.}

\item{save_data}{Logical, save results in locally specified folder. Default is FALSE}

\item{file_name}{The name for periodically saved rank_percent data file. Default is "dat_rank_percent".}

\item{dir_path}{The path for periodically saved rank_percent data file Default is "tempdir()"}

\item{...}{Additional parameters.}

\item{x}{The name of an independent variable.}
}
\value{
Data.frame with new processed variables.
}
\description{
\code{ranking_percent_proc} is for processing ranking percent variables.
\code{ranking_percent_dict} is for generating ranking percent dictionary.
}
\examples{
rank_dict = ranking_percent_dict(dat = UCICreditCard[1:1000,],
x_list = c("LIMIT_BAL","BILL_AMT2","PAY_AMT3"), ex_cols = NULL )
UCICreditCard_new = ranking_percent_proc(dat = UCICreditCard[1:1000,],
x_list = c("LIMIT_BAL", "BILL_AMT2", "PAY_AMT3"), rank_dict = rank_dict, parallel = FALSE)
}
