% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_data.r
\docType{data}
\name{lendingclub}
\alias{lendingclub}
\title{Lending Club data}
\format{
A data frame with 63532 rows and 145 variables.
}
\description{
This data contains complete loan data for all loans issued through the time period stated, including the current loan status (Current, Late, Fully Paid, etc.) and latest payment information.
 The data containing loan data through the "present" contains complete loan data for all loans issued through the previous completed calendar quarter(time period: 2018Q1:2018Q4).
}
\details{
\itemize{
  \item id: A unique LC assigned ID for the loan listing.
  \item issue_d: The month which the loan was funded.
  \item loan_status: Current status of the loan.
  \item addr_state: The state provided by the borrower in the loan application.
  \item acc_open_past_24mths: Number of trades opened in past 24 months.
  \item all_util: Balance to credit limit on all trades.
  \item annual_inc: The self:reported annual income provided by the borrower during registration.
  \item avg_cur_bal: Average current balance of all accounts.
  \item bc_open_to_buy: Total open to buy on revolving bankcards.
  \item bc_util: Ratio of total current balance to high credit/credit limit for all bankcard accounts.
  \item dti: A ratio calculated using the borrower's total monthly debt payments on the total debt obligations, excluding mortgage and the requested LC loan, divided by the borrower's self:reported monthly income.
  \item dti_joint: A ratio calculated using the co:borrowers' total monthly payments on the total debt obligations, excluding mortgages and the requested LC loan, divided by the co:borrowers' combined self:reported monthly income
  \item emp_length: Employment length in years. Possible values are between 0 and 10 where 0 means less than one year and 10 means ten or more years.
  \item emp_title: The job title supplied by the Borrower when applying for the loan.
  \item funded_amnt_inv: The total amount committed by investors for that loan at that point in time.
  \item grade: LC assigned loan grade
  \item inq_last_12m: Number of credit inquiries in past 12 months
  \item installment: The monthly payment owed by the borrower if the loan originates.
  \item max_bal_bc: Maximum current balance owed on all revolving accounts
  \item mo_sin_old_il_acct: Months since oldest bank installment account opened
  \item mo_sin_old_rev_tl_op: Months since oldest revolving account opened
  \item mo_sin_rcnt_rev_tl_op: Months since most recent revolving account opened
  \item mo_sin_rcnt_tl: Months since most recent account opened
  \item mort_acc: Number of mortgage accounts.
  \item pct_tl_nvr_dlq: Percent of trades never delinquent
  \item percent_bc_gt_75: Percentage of all bankcard accounts > 75% of limit.
  \item purpose: A category provided by the borrower for the loan request.
  \item sub_grade: LC assigned loan subgrade
  \item term: The number of payments on the loan. Values are in months and can be either 36 or 60.
  \item tot_cur_bal: Total current balance of all accounts
  \item tot_hi_cred_lim: Total high credit/credit limit
  \item total_acc: The total number of credit lines currently in the borrower's credit file
  \item total_bal_ex_mort: Total credit balance excluding mortgage
  \item total_bc_limit: Total bankcard high credit/credit limit
  \item total_cu_tl: Number of finance trades
  \item total_il_high_credit_limit: Total installment high credit/credit limit
  \item verification_status_joint: Indicates if the co:borrowers' joint income was verified by LC, not verified, or if the income source was verified
  \item zip_code: The first 3 numbers of the zip code provided by the borrower in the loan application.
}
}
\seealso{
\code{\link{UCICreditCard}}
}
\keyword{datasets}
