% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pd_to_spread.R
\name{pd_to_spread}
\alias{pd_to_spread}
\title{Calculate spread with Default Probability}
\usage{
pd_to_spread(x, recovery.var = "recovery", currency.var = "currency",
  tenor.var = "tenor", date.var = "date", pd.var = "pd")
}
\arguments{
\item{x}{data frame, contains all the relevant columns.}

\item{recovery.var}{character, column in x containing recovery rates. ISDA
model standard recovery rate asscumption is 0.4.}

\item{currency.var}{character, column in x containing currency.}

\item{tenor.var}{character, column in x containing tenors.}

\item{date.var}{character, column in x containing date variable.}

\item{pd.var}{name of the column containing the probability of default in
  decimals.}
}
\value{
vector containing the spread values in basis points, calculated by
  inverting the formula for probability of default given in the Bloomberg
  Manual
}
\description{
\code{pd_to_spread} to calculate spread using the probability of default,
tenor and recovery rate.
}
\seealso{
\code{\link{spread_to_pd}}
}

