% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_async.R
\name{crew_eval_async}
\alias{crew_eval_async}
\title{Run an asynchronous task in the crew launcher.}
\usage{
crew_eval_async(
  command,
  data = list(),
  packages = character(0L),
  library = NULL
)
}
\arguments{
\item{command}{Language object with R code to run.}

\item{data}{Named list of objects that \code{command} depends on.}

\item{packages}{Character vector of packages to load.}

\item{library}{Character vector of library paths to load the packages from.}
}
\value{
The result of running \code{command}.
}
\description{
Called internally, not for users.
}
\seealso{
Other utilities: 
\code{\link{crew_assert}()},
\code{\link{crew_deprecate}()},
\code{\link{crew_eval}()},
\code{\link{crew_random_name}()},
\code{\link{crew_retry}()},
\code{\link{crew_worker}()}
}
\concept{utilities}
\keyword{internal}
