% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/caseUtils.R
\name{getCrimeSeries}
\alias{getCrimeSeries}
\title{Generate a list of offenders and their associated crime series.}
\usage{
getCrimeSeries(offenderID, offenderTable, restrict = NULL, show.pb = FALSE)
}
\arguments{
\item{offenderID}{vector of offender IDs}

\item{offenderTable}{offender table that indicates the offender(s) responsible
  for solved crimes. \code{offenderTable} must have columns named:
  \code{offenderID} and \code{crimeID}.}

\item{restrict}{if vector of \code{crimeID}, then only include those crimeIDs
  in \code{offenderTable}. If \code{NULL}, then return all crimes for offender.}

\item{show.pb}{(logical) should a progress bar be displayed}
}
\value{
List of offenders with their associated crime series.
}
\description{
Generate a list of offenders and their associated crime series.
}
\examples{
data(offenders)

 getCrimeSeries("O:40",offenders)
 getCrimeSeries(c("O:40","O:3"),offenders)  # list of crime series from multiple offenders
}
\seealso{
\code{\link{makeSeriesData}}, \code{\link{getCriminals}},
   \code{\link{makeSeriesData}}
}

