% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_schedule.R
\name{sch_reference}
\alias{sch_reference}
\title{Reference}
\usage{
sch_reference(sch, new_value = NULL)
}
\arguments{
\item{sch}{A schedule object.}

\item{new_value}{A new reference.}
}
\value{
\itemize{
\item A schedule object with new reference.
\item A reference.
}
}
\description{
A reference from project origin, for example, a book, a paper, a corporation,
or nothing.
}
\examples{
sch <- sch_new() \%>\%
  sch_add_activities(
    id = c(1L, 2L, 3L, 4L),
    name = c("A", "B", "C", "D"),
    duration = c(3L, 4L, 9L, 1L)
  ) \%>\%
  sch_add_relations(
    from = c(1L, 2L, 2L),
    to   = c(2L, 3L, 4L)
  ) \%>\%
  sch_plan()

sch_reference(sch) # empty
sch \%<>\% sch_reference("This schedule is from...")
sch_reference(sch)

}
\seealso{
\code{\link[=sch_new]{sch_new()}}, \code{\link[=sch_activities]{sch_activities()}}, \code{\link[=sch_relations]{sch_relations()}}, \code{\link[=sch_title]{sch_title()}},
\code{\link[=sch_plan]{sch_plan()}}, \code{\link[=sch_duration]{sch_duration()}}, \code{\link[=sch_validate]{sch_validate()}}.
}
