% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_schedule.R
\name{sch_xy_gantt_matrix}
\alias{sch_xy_gantt_matrix}
\title{XY Gantt Matrix}
\usage{
sch_xy_gantt_matrix(sch, gantt = NULL)
}
\arguments{
\item{sch}{A schedule object.}

\item{gantt}{A Gantt Matrix. If it is not informed, it will use
\code{gantt_matrix()} before this function.}
}
\value{
A matrix with three columns: x, y and weight.
}
\description{
Transform a Gantt matrix into x, y coordinates and the weight one.
Each point greater than zero in a Gantt matrix becomes a x, y coordinate.
\strong{Atention:} the schedule must be planned with the function \code{sch_plan()}.
}
\examples{
sch <- sch_new() \%>\%
  sch_add_activities(
    id        = c( 1L,  2L,  3L,  4L),
    name      = c("A", "B", "C", "D"),
    duration  = c( 2L,  3L,  1L, 2L )
  ) \%>\%
  sch_add_relations(
    from = c(1L, 2L, 4L, 4L),
    to   = c(3L, 3L, 1L, 2L)
  ) \%>\%
  sch_plan()

sch_duration(sch)

xyw <- sch_xy_gantt_matrix(sch)
xyw
plot(xyw[, 1:2])

}
\seealso{
\code{\link[=sch_relations]{sch_relations()}}, \code{\link[=sch_activities]{sch_activities()}}, \code{\link[=sch_add_activities]{sch_add_activities()}},
\code{\link[=sch_add_relations]{sch_add_relations()}}, \code{\link[=sch_add_relation]{sch_add_relation()}}, \code{\link[=sch_plan]{sch_plan()}},
\code{\link[=sch_gantt_matrix]{sch_gantt_matrix()}}.
}
