% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Data-methods.R
\docType{methods}
\name{getEff}
\alias{getEff}
\alias{getEff,DataDual-method}
\title{Extracting efficacy responses for subjects without or with a DLE. This is a class where we separate
efficacy responses with or without a DLE. It outputs the efficacy responses and their corresponding
dose levels treated at in two categories (with or without DLE)}
\usage{
getEff(object, ...)

\S4method{getEff}{DataDual}(object, x, y, w, ...)
}
\arguments{
\item{object}{for data input from \code{\linkS4class{DataDual}} object}

\item{x}{todo}

\item{y}{todo}

\item{w}{todo}

\item{\dots}{unused}
}
\description{
Extracting efficacy responses for subjects without or with a DLE. This is a class where we separate
efficacy responses with or without a DLE. It outputs the efficacy responses and their corresponding
dose levels treated at in two categories (with or without DLE)
}
\section{Methods (by class)}{
\itemize{
\item \code{DataDual}: 
}}
\examples{
## Separate the efficacy responses of subjects with or without DLE
## data must be specified for in 'DataDual' class
data<-DataDual(x=c(25,50,25,50,75,300,250,150),
               y=c(0,0,0,0,0,1,1,0),
               w=c(0.31,0.42,0.59,0.45,0.6,0.7,0.6,0.52),
               doseGrid=seq(25,300,25))
##Display the efficacy response and their corresponding dose levels 
## treated at when no or a DLE is observed
getEff(data)
}
\keyword{methods}

