% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestNCRM-class}
\alias{NextBestNCRM-class}
\alias{.NextBestNCRM}
\alias{NextBestNCRM}
\alias{.DefaultNextBestNCRM}
\title{\code{NextBestNCRM}}
\usage{
NextBestNCRM(target, overdose, max_overdose_prob)

.DefaultNextBestNCRM()
}
\arguments{
\item{target}{(\code{numeric})\cr see slot definition.}

\item{overdose}{(\code{numeric})\cr see slot definition.}

\item{max_overdose_prob}{(\code{proportion})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{NextBestNCRM}} is the class for next best dose that finds the next dose
with high posterior probability to be in the target toxicity interval.
}
\details{
To avoid numerical problems, the dose selection algorithm has been
implemented as follows: First admissible doses are found, which are those
with probability to fall in \code{overdose} category being below \code{max_overdose_prob}.
Next, within the admissible doses, the maximum probability to fall in the
\code{target} category is calculated. If that is above 5\% (i.e. it is not just
numerical error), then the corresponding dose is the next recommended dose.
Otherwise, the highest admissible dose is the next recommended dose.
}
\section{Slots}{

\describe{
\item{\code{target}}{(\code{numeric})\cr the target toxicity interval (limits included).}

\item{\code{overdose}}{(\code{numeric})\cr the overdose toxicity interval (lower limit
excluded, upper limit included). It is used to filter probability samples.}

\item{\code{max_overdose_prob}}{(\code{proportion})\cr maximum overdose posterior
probability that is allowed, except 0 or 1.}
}}

\note{
Typically, end users will not use the \code{.DefaultNextBestNCRM()} function.
}
\examples{
# In the example below, the target toxicity interval [0.2, 0.35] while the
# overdose interval is (0.35,1]. Finally we would like to constrain the
# probability of overdosing below 25\%.
my_next_best <- NextBestNCRM(
  target = c(0.2, 0.35),
  overdose = c(0.35, 1),
  max_overdose_prob = 0.25
)
}
