% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{cross_summary}
\alias{cross_summary}
\title{Summarize a numeric vector}
\usage{
cross_summary(x, dig = 1, ...)
}
\arguments{
\item{x}{a numeric vector}

\item{dig}{number of digits}

\item{...}{params to pass on to \code{\link[=format_fixed]{format_fixed()}}: \code{zero_digits} and \code{only_round}}
}
\value{
a list of named functions
}
\description{
Summarize a numeric vector with min, max, mean, sd, median, IQR, n and missings.
}
\examples{
cross_summary(iris$Sepal.Length)
cross_summary(iris$Petal.Width, dig=3)
cross_summary(mtcars2$hp_date)
cross_summary(mtcars2$qsec_posix, date_format="\%d/\%m \%H:\%M")
}
