% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube-result.R, R/tab-book.R
\docType{methods}
\name{cube-computing}
\alias{cube-computing}
\alias{margin.table}
\alias{prop.table}
\alias{bases}
\alias{round}
\alias{margin.table,CrunchCube-method}
\alias{prop.table,CrunchCube-method}
\alias{round,CrunchCube-method}
\alias{bases,CrunchCube-method}
\alias{prop.table,MultitableResult-method}
\alias{prop.table,TabBookResult-method}
\alias{bases,TabBookResult-method}
\alias{bases,MultitableResult-method}
\title{Work with CrunchCubes, MultitableResults, and TabBookResults}
\usage{
\S4method{margin.table}{CrunchCube}(x, margin = NULL)

\S4method{prop.table}{CrunchCube}(x, margin = NULL)

\S4method{round}{CrunchCube}(x, digits = 0)

\S4method{bases}{CrunchCube}(x, margin = NULL)

\S4method{prop.table}{MultitableResult}(x, margin = NULL)

\S4method{prop.table}{TabBookResult}(x, margin = NULL)

\S4method{bases}{TabBookResult}(x, margin = NULL)

\S4method{bases}{MultitableResult}(x, margin = NULL)
}
\arguments{
\item{x}{a CrunchCube}

\item{margin}{index, or vector of indices to generate margin for. See
\code{\link[base:prop.table]{base::prop.table()}}. \code{bases()} accepts \code{0} as an additional valid
value for \code{margin}, which yields the unweighted counts for the
query.}

\item{digits}{For \code{round}, the number of decimal places to round to. See
\code{\link[base:round]{base::round()}}}
}
\value{
When called on CrunchCubes, these functions return an \code{array}.
Calling prop.table on
a MultitableResult returns a list of prop.tables of the CrunchCubes it
contains. Likewise, prop.table on a TabBookResult returns a list of lists of
prop.tables.
}
\description{
These functions provide an interface like \code{\link[base:margin.table]{base::margin.table()}}
and \code{\link[base:prop.table]{base::prop.table()}} for the CrunchCube object. CrunchCubes contain
richer metadata than standard R \code{array} objects, and they also conceal
certain complexity in the data structures from the user. In particular,
multiple-response variables are generally represented as single dimensions
in result tables, but in the actual data, they may comprise two dimensions.
These methods understand the subtleties in the Crunch data types and
correctly compute margins and percentages off of them.
}
\details{
These functions also generalize to MultitableResults and TabBookResults,
which are returned from a \code{\link[=tabBook]{tabBook()}} request. When called on one of those
objects, they effectively apply over each CrunchCube contained in them.

\code{bases} is an additional method for CrunchCubes. When making weighted
requests, \code{bases} allows you to access the unweighted counts for every
cell in the resulting table (array). The \code{bases} function takes a
"margin" argument to work like \code{margin.table}, or with \code{margin=0}
gives all cell counts.
}
\seealso{
\code{\link[base:margin.table]{base::margin.table()}} \code{\link[base:prop.table]{base::prop.table()}}
}
