% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry.R
\name{op_xyz_to_matrix}
\alias{op_xyz_to_matrix}
\title{Human-readable symmetry operator into matrix and vector}
\usage{
op_xyz_to_matrix(op_xyz)
}
\arguments{
\item{op_xyz}{A symmetry or centering operation in the form of a
human-readable string, e.g. -x+1/2,-y,z+1/2'.}
}
\value{
mat_ops A named list including a \eqn{3\times 3} matrix 'R' and a
                \eqn{3\times 1} vector 'T'.
}
\description{
Returns a \eqn{3\times 3} matrix and \eqn{3\times 1} vector corresponding to either a
symmetry operator or a centering operator in human-readable, string form.
}
\details{
A string describing a symmetry or a centering operation has a format similar to, for instance,
'-x+1/2,-y,z+1/2'. Such a string corresponds to the symmetry operation represented
mathematically by the following matrix and vector:
\deqn{
  \left(\begin{array}{rrr}
  -1 & 0 & 0 \\
  0 & -1 & 0 \\
  0 & 0 & 1
  \end{array}\right)\quad,\quad
  \left(\begin{array}{r}
  1/2 \\
  0 \\
  1/2
  \end{array}\right)
}
Where symmetry operations in human-readable form are useful for the subjective reasoning
in crystallography, their mathematical counterpart is needed for all practical calculations.
}
\examples{
# Reflection and translation
sop <- '-x,y+1/2,z'
mat_ops <- op_xyz_to_matrix(sop)
print(mat_ops)

}
