% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableTickers.R
\name{availableTickers}
\alias{availableTickers}
\title{Get all the available tickers
on the desired exchange and market}
\usage{
availableTickers(source = "binance", futures = TRUE)
}
\arguments{
\item{source}{a character vector of length 1. The source of the API}

\item{futures}{a logical value. Default TRUE.}
}
\value{
Returns a character vector
of length N equal to the tradable tickers
}
\description{
This function returns all available
pairs on the exchanges.
}
\examples{
## available tickers
## in Binance spot market
head(
  try(
    cryptoQuotes::availableTickers(
      source = 'binance',
      futures = FALSE
    )
  )
)


## available tickers
## in Kraken futures market
head(
  try(
    cryptoQuotes::availableTickers(
      source = 'kraken',
      futures = TRUE
    )
  )
)


}
