% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart.R
\name{chart}
\alias{chart}
\title{Create an interactive financial chart}
\usage{
chart(chart, slider = TRUE)
}
\arguments{
\item{chart}{a \code{\link[=kline]{kline()}} or \code{\link[=ohlc]{ohlc()}} chart with optional indicators.}

\item{slider}{A logical value. \link{TRUE} by default. Include a slider in the bottom of the chart.}
}
\value{
Returns a plotly object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Chart the \code{\link[=kline]{kline()}} or \code{\link[=ohlc]{ohlc()}} with optional indicators.
}
\examples{
# script: scr_charting
# date: 2023-10-25
# author: Serkan Korkmaz, serkor1@duck.com
# objective: Charting in general
# script start;

# library
library(cryptoQuotes)

# charting klines
# with various indicators
chart(
  chart = kline(
    ATOMUSDT
  ) \%>\% addVolume() \%>\% addMA(
    FUN = TTR::SMA,
    n = 7
  ) \%>\% addMA(
    FUN = TTR::SMA,
    n = 14
  ) \%>\%
    addBBands() \%>\%
    addMACD() \%>\%
    addRSI()

)


# script end;
}
\seealso{
Other chart indicators: 
\code{\link{addBBands}()},
\code{\link{addEvents}()},
\code{\link{addFGIndex}()},
\code{\link{addLSRatio}()},
\code{\link{addMACD}()},
\code{\link{addMA}()},
\code{\link{addRSI}()},
\code{\link{addVolume}()}

Other charting: 
\code{\link{kline}()},
\code{\link{ohlc}()}
}
\concept{chart indicators}
\concept{charting}
