/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.vividsolutions.jts.util.Stopwatch;

public class DebugTimer {
    private static final int TIME_LEN = 10;
    private static DebugTimer timer = new DebugTimer();
    private Stopwatch sw = new Stopwatch();
    private String blankStr;

    public DebugTimer() {
        this.sw.start();
        this.blankStr = this.fillString(10, ' ');
    }

    public static void startStatic(String msg) {
        timer.start(msg);
    }

    public static void logEventStatic(String msg) {
        timer.logEvent(msg);
    }

    public void start(String msg) {
        System.out.println("Started    " + msg);
        this.sw.start();
    }

    public void logEvent(String msg) {
        String elapsedStr = this.formatTime(this.sw.getTimeString());
        System.out.println("Elapsed: " + elapsedStr + "    " + msg);
        this.sw.start();
    }

    public String formatTime(String timeStr) {
        if (timeStr.length() < 10) {
            String filled = this.blankStr + timeStr;
            int start = filled.length() - 10;
            return filled.substring(start);
        }
        return timeStr;
    }

    public String fillString(int len, char ch) {
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            buf.append(ch);
        }
        return buf.toString();
    }
}

