/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class EdgeList {
    private List edges = new ArrayList();
    private SpatialIndex index = new Quadtree();

    public void add(Edge e) {
        this.edges.add(e);
        this.index.insert(e.getEnvelope(), e);
    }

    public void addAll(Collection edgeColl) {
        Iterator i = edgeColl.iterator();
        while (i.hasNext()) {
            this.add((Edge)i.next());
        }
    }

    public List getEdges() {
        return this.edges;
    }

    public Edge findEqualEdge(Edge e) {
        List testEdges = this.index.query(e.getEnvelope());
        Iterator i = testEdges.iterator();
        while (i.hasNext()) {
            Edge testEdge = (Edge)i.next();
            if (!testEdge.equals(e)) continue;
            return testEdge;
        }
        return null;
    }

    public Iterator iterator() {
        return this.edges.iterator();
    }

    public Edge get(int i) {
        return (Edge)this.edges.get(i);
    }

    public int findEdgeIndex(Edge e) {
        for (int i = 0; i < this.edges.size(); ++i) {
            if (!((Edge)this.edges.get(i)).equals(e)) continue;
            return i;
        }
        return -1;
    }

    public void print(PrintStream out) {
        out.print("MULTILINESTRING ( ");
        for (int j = 0; j < this.edges.size(); ++j) {
            Edge e = (Edge)this.edges.get(j);
            if (j > 0) {
                out.print(",");
            }
            out.print("(");
            Coordinate[] pts = e.getCoordinates();
            for (int i = 0; i < pts.length; ++i) {
                if (i > 0) {
                    out.print(",");
                }
                out.print(pts[i].x + " " + pts[i].y);
            }
            out.println(")");
        }
        out.print(")  ");
    }
}

