/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleUtil;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;

public class PolygonizerPlugIn
extends ThreadedBasePlugIn {
    private boolean useSelected = false;
    private MultiInputDialog dialog;
    private String layerName;
    private boolean splitLineStrings = false;
    private boolean nodeInputLines = false;
    private int inputEdgeCount = 0;
    private int dangleCount = 0;
    private int cutCount = 0;
    private int invalidRingCount = 0;
    private GeometryFactory fact = new GeometryFactory();
    private static final String SRC_LAYER = "Line Layer:";
    private static final String NODE_INPUT = "Node input before polygonizing";
    private static final String SELECTED_ONLY = "Use selected features only";

    public String getName() {
        return "Polygonize";
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), "Polygonize", true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow((Component)this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Collection lines;
        monitor.allowCancellationRequests();
        Polygonizer polygonizer = new Polygonizer();
        monitor.report("Polygonizing...");
        Layer layer = this.dialog.getLayer(SRC_LAYER);
        Collection inputFeatures = this.getFeaturesToProcess(layer, context);
        this.inputEdgeCount = inputFeatures.size();
        Collection nodedLines = lines = this.getLines(inputFeatures);
        if (this.nodeInputLines) {
            monitor.report("Noding input lines");
            nodedLines = this.nodeLines((List)lines);
        }
        Iterator i = nodedLines.iterator();
        while (i.hasNext()) {
            Geometry g = (Geometry)i.next();
            polygonizer.add(g);
        }
        if (monitor.isCancelRequested()) {
            return;
        }
        this.createLayers(context, polygonizer);
    }

    private Collection getFeaturesToProcess(Layer lyr, PlugInContext context) {
        if (this.useSelected) {
            return context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(lyr);
        }
        return lyr.getFeatureCollectionWrapper().getFeatures();
    }

    private Collection getLines(Collection inputFeatures) {
        ArrayList linesList = new ArrayList();
        LinearComponentExtracter lineFilter = new LinearComponentExtracter(linesList);
        Iterator i = inputFeatures.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            Geometry g = f.getGeometry();
            g.apply((GeometryComponentFilter)lineFilter);
        }
        return linesList;
    }

    private Collection nodeLines(Collection lines) {
        MultiLineString linesGeom = this.fact.createMultiLineString(GeometryFactory.toLineStringArray((Collection)lines));
        MultiLineString unionInput = this.fact.createMultiLineString(null);
        Geometry point = this.extractPoint(lines);
        if (point != null) {
            unionInput = point;
        }
        Geometry noded = linesGeom.union((Geometry)unionInput);
        ArrayList<Geometry> nodedList = new ArrayList<Geometry>();
        nodedList.add(noded);
        return nodedList;
    }

    private Geometry extractPoint(Collection lines) {
        int minPts = Integer.MAX_VALUE;
        Point point = null;
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            Geometry g = (Geometry)i.next();
            if (g.isEmpty()) continue;
            Coordinate p = g.getCoordinate();
            point = g.getFactory().createPoint(p);
        }
        return point;
    }

    private void createLayers(PlugInContext context, Polygonizer polygonizer) throws Exception {
        FeatureCollection dangleFC = FeatureDatasetFactory.createFromGeometry(polygonizer.getDangles());
        this.dangleCount = dangleFC.size();
        if (dangleFC.size() > 0) {
            Layer lyr4 = context.addLayer("QA", "Dangles", dangleFC);
            LayerStyleUtil.setLinearStyle((Layer)lyr4, (Color)Color.red, (int)2, (int)0);
            lyr4.setDescription("Dangling edges");
        }
        FeatureCollection cutFC = FeatureDatasetFactory.createFromGeometry(polygonizer.getCutEdges());
        this.cutCount = cutFC.size();
        if (cutFC.size() > 0) {
            Layer lyr = context.addLayer("QA", "Cuts", cutFC);
            LayerStyleUtil.setLinearStyle((Layer)lyr, (Color)Color.blue, (int)2, (int)0);
            lyr.setDescription("Cut edges");
        }
        FeatureCollection invalidRingFC = FeatureDatasetFactory.createFromGeometry(polygonizer.getInvalidRingLines());
        this.invalidRingCount = invalidRingFC.size();
        if (invalidRingFC.size() > 0) {
            Layer lyr = context.addLayer("QA", "Invalid Rings", invalidRingFC);
            LayerStyleUtil.setLinearStyle((Layer)lyr, (Color)Color.blue, (int)2, (int)0);
            lyr.setDescription("Invalid rings");
        }
        FeatureCollection polyFC = FeatureDatasetFactory.createFromGeometry(polygonizer.getPolygons());
        context.addLayer("Result", this.layerName + " Polygons", polyFC);
        this.createOutput(context, polyFC);
    }

    private void createOutput(PlugInContext context, FeatureCollection polyFC) {
        context.getOutputFrame().createNewDocument();
        context.getOutputFrame().addHeader(1, "Polygonization");
        context.getOutputFrame().addField("Layer: ", this.layerName);
        context.getOutputFrame().addText(" ");
        context.getOutputFrame().addField("# Input Edges: ", "" + this.inputEdgeCount);
        context.getOutputFrame().addField("# Polygons Created: ", "" + polyFC.size());
        context.getOutputFrame().addField("# Dangling Edges found: ", "" + this.dangleCount);
        context.getOutputFrame().addField("# Cut Edges found: ", "" + this.cutCount);
        context.getOutputFrame().addField("# Invalid Rings found: ", "" + this.invalidRingCount);
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("Polygonize.png")));
        dialog.setSideBarDescription("Polygonizes the line segments in a layer. Polygonization requires correctly noded data. If desired the input data may be noded before polygonizing is performed. Dangles, Cutlines and Invalid Rings are identified.");
        String fieldName = SRC_LAYER;
        JComboBox addLayerComboBox = dialog.addLayerComboBox(fieldName, context.getCandidateLayer(0), null, context.getLayerManager());
        dialog.addCheckBox(SELECTED_ONLY, this.useSelected);
        dialog.addCheckBox(NODE_INPUT, this.nodeInputLines, "Node input before polygonizing.");
    }

    private void getDialogValues(MultiInputDialog dialog) {
        Layer layer = dialog.getLayer(SRC_LAYER);
        this.layerName = layer.getName();
        this.useSelected = dialog.getBoolean(SELECTED_ONLY);
        this.nodeInputLines = dialog.getBoolean(NODE_INPUT);
    }
}

