% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_csquares.R
\name{new_csquares}
\alias{new_csquares}
\title{Create a c-squares raster from a bounding box}
\usage{
new_csquares(x, resolution = 1, crs = 4326)
}
\arguments{
\item{x}{An object of class \code{\link[sf:st_bbox]{bbox}} or an object that can be coerced to a \code{bbox}.
It defines the bounding box for the c-squares grid created by this function.}

\item{resolution}{Resolution (in WGS84 degrees) to be used for creating c-squares codes.
As per c-square specifications, the resolution should be 10 or less, yet greater than 0.
It should be a tenfold of 1 or 5. Valid resolutions are therefore: 10, 5, 1, 0.5, 0.1, etc.}

\item{crs}{The projection to be used for the created grid. By default it is WGS84 (EPSG:4326).}
}
\value{
Returns a \code{\link[stars:st_as_stars]{stars}} and \code{csquares} object based on the provided bounding box and
resolution.
}
\description{
Creates a spatial raster (\code{\link[stars:st_as_stars]{stars}}) with c-square codes for a specified bounding box,
using a specified resolution. The raster will be conform c-squares specifications.
}
\examples{
library(sf)
nc <- st_read(system.file("shape/nc.shp", package = "sf"))
new_csquares(nc)
}
\author{
Pepijn de Vries
}
