% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotranking.R
\name{plot.csranks}
\alias{plot.csranks}
\alias{plotranking}
\title{Plot ranking with confidence sets}
\usage{
\method{plot}{csranks}(x, ...)

plotranking(
  ranks,
  L,
  U,
  popnames = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  colorbins = 1,
  horizontal = TRUE
)
}
\arguments{
\item{x}{An \code{csranks} object, likely produced by \code{\link{csranks}}.}

\item{...}{Other arguments, passed to \code{plotranking}.}

\item{ranks}{vector of ranks}

\item{L}{vector of lower bounds of confidence sets for the ranks}

\item{U}{vector of lower bounds of confidence sets for the ranks}

\item{popnames}{vector containing names of the populations whose ranks are in \code{ranks}. If \code{popnames=NULL} (default), then populations are automatically numbered.}

\item{title}{character string containing the main title of the graph. \code{title=NULL} (default) means no title.}

\item{subtitle}{character string containing the subtitle of the graph. \code{subtitle=NULL} (default) means no subtitle.}

\item{caption}{character string containing the caption of the graph. \code{caption=NULL} (default) means no caption.}

\item{colorbins}{integer indicating the number of quantile bins into which populations are grouped and color-coded. Value has to lie between 1 (default) and the number of populations.}

\item{horizontal}{logical. Should be the bars displayed horizontally, or vertically?}
}
\value{
A ggplot plot displaying confidence sets.
}
\description{
Display ranks together with their confidence set bounds.
}
\section{Functions}{
\itemize{
\item \code{plot(csranks)}: Plot \code{csranks} output

}}
\examples{
x <- seq(1, 3, length = 10)
V <- diag(rep(0.04, 10))
CS <- csranks(x, V)
grid::current.viewport()
plot(CS)
# Equivalent: 
plotranking(CS$rank, CS$L, CS$U)

# plotranking returns a ggplot object. It can be customized further:
library(ggplot2)
pl <- plot(CS)
pl + xlab("position in ranking") + ylab("population label") + theme_gray()

# horizontal = FALSE uses ggplot2::coord_flip underneath. The x and y axes swap places.
pl <- plot(CS, horizontal = FALSE)
pl + xlab("position in ranking") + # Note, that xlab refers to vertical axis now
  ylab("population label") + theme_gray()
}
