% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcf_to_mutations_df.R
\name{vcf_to_mutations_df}
\alias{vcf_to_mutations_df}
\title{Helper function to read a vcf into the required format of mutations data frame}
\usage{
vcf_to_mutations_df(vcf, sample_name = NULL, ...)
}
\arguments{
\item{vcf}{the path to vcf file}

\item{sample_name}{a character(1) when provided, return only variants from this sample}

\item{...}{other options passed to VariantAnnotation::readVcfAsVRanges}
}
\description{
Uses VariantAnnotation::readVcfAsVRanges to read the vcf file, which return variants
in a format that each row is one variant. If the vcf has multiple samples, the samples
will be appended by rows. Provide a sample_name to return only the variants belonging
to the sample of interest. Once you use this function, make sure that all the variants
are relevant. The function will only return SNVs.
}
\examples{
\donttest{
vcf <- system.file("extdata", "chr22.vcf.gz", package="VariantAnnotation")
vcf_to_mutations_df(vcf, sample_name = "HG00096")
}

}
