% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dbFindFields}
\alias{dbFindFields}
\title{Find names of fields in the database collection}
\usage{
dbFindFields(namepart = "", allmatches = TRUE, debug = FALSE,
  collection = "ctrdata", uri = "mongodb://localhost/users",
  password = Sys.getenv("ctrdatamongopassword"), verbose = FALSE)
}
\arguments{
\item{namepart}{A plain string (not a regular expression) to be searched for
among all field names (keys) in the database.}

\item{allmatches}{If \code{TRUE} (default), returns all keys if more than one is found,
returns only first if \code{FALSE}.}

\item{debug}{If \code{TRUE}, prints additional information (default \code{FALSE}).}

\item{collection}{Name of collection (default is "ctrdata")}

\item{uri}{Default is mongodb://localhost/users/.
Address of database in mongodb server, based on mongo connection string
format: mongodb://[username@]host1[:port1][,...hostN[:portN]]]/database/
Do NOT include password, this will only be used from the parameter.
See \url{http://docs.mongodb.org/manual/reference/connection-string/}}

\item{password}{In case access requires credentials.
Note this defaults to the environment variable "ctrdatamongopassword".
(by means of \code{Sys.getenv("ctrdatamongopassword")}), to
support scripting without revealing secrets.}

\item{verbose}{Print information.}
}
\value{
Vector of field(s) found
}
\description{
Given part of the name of a field of interest to the user, this function
returns the full field names as found in the database. It is not necessary to
add wild cards to the name of the field of interest.
}
\details{
For fields in EUCTR (protocol- and results-related information), see also the
register's documentation: \url{https://eudract.ema.europa.eu/}.

For fields in CTGOV (protocol-related information), see also the register's
definitions: \url{https://prsinfo.clinicaltrials.gov/definitions.html}

Note that generating a list of fields with this function may take some time,
since a mapreduce function is run on the server. If the user is not
not authorised to run such a function on the (local or remote) server,
random documents are samples to generate a list of fields.
}
\examples{

\dontrun{
 dbFindFields("date")
}

}
