% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestKeeper.R
\name{bki}
\alias{bki}
\title{Analyzes genes versus BestKeeper index}
\usage{
bki(expression, ctVal = TRUE)
}
\arguments{
\item{expression}{a matrix of expression levels. Each row corresponds to a sample and each column to a gene.}

\item{ctVal}{a logical value indicating data type. If ct-values are input, ctVal=TRUE, otherwise, ctVal=FALSE.}
}
\value{
A matrix of the Pearson correlation coefficient (r), coefficient of determination (r2) and the p-value.
}
\description{
All genes are combined into an index. Then, correlation between each genes and the index is calculated, describing the relation between the index and the contributing gene by the Pearson correlation coefficient (r), coefficient of determination (r2) and the p-value.
}
\examples{
FIBct
bki(FIBct)
}
\references{
Pfaffl MW, Tichopad A, Prgomet C, Neuvians TP. Biotechnol Lett (2004) <doi: 10.1023/B:BILE.0000019559.84305.47>
}
