% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ctCI.R
\name{ctCI}
\alias{ctCI}
\title{ctCI
Computes confidence intervals on specified parameters / matrices for already fitted ctsem fit object.}
\usage{
ctCI(ctfitobj, confidenceintervals, optimizer = "NPSOL", verbose = 0)
}
\arguments{
\item{ctfitobj}{Already fit ctsem fit object (class: ctsemFit) to estimate confidence intervals for.}

\item{confidenceintervals}{character vector of matrices and or parameters for which to estimate 95\% confidence intervals for.}

\item{optimizer}{character vector. Defaults to NPSOL (recommended), but other optimizers available within OpenMx (e.g. 'SLSQP') may be specified.}

\item{verbose}{Integer between 0 and 3 reflecting amount of output while calculating.}
}
\value{
ctfitobj, with confidence intervals included.
}
\description{
ctCI
Computes confidence intervals on specified parameters / matrices for already fitted ctsem fit object.
}
\details{
Confidence intervals typically estimate more reliably using the proprietary NPSOL optimizer available within OpenMx only when
installing directly from OpenMx website. Use command " source('http://openmx.psyc.virginia.edu/getOpenMx.R') " to install OpenMx with NPSOL.
If estimating for a multigroup model, specify confidence intervals as normal, e.g. \code{confidenceintervals = c('DRIFT', 'diffusion_Y1_Y1')} .
The necessary group prefixes are added internally.
}
\examples{
data("ctExample3")
model <- ctModel(n.latent = 1, n.manifest = 3, Tpoints = 100,
 LAMBDA = matrix(c(1, "lambda2", "lambda3"), nrow = 3, ncol = 1),
 MANIFESTMEANS = matrix(c(0, "manifestmean2", "manifestmean3"), nrow = 3,
   ncol = 1))
fit <- ctFit(data = ctExample3, ctmodelobj = model, objective = "Kalman",
 stationary = c("T0VAR"))

fit <- ctCI(fit, confidenceintervals = 'DRIFT')
}

