% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctCheckFit.R
\name{ctCheckFit}
\alias{ctCheckFit}
\title{Check absolute fit of ctFit or ctStanFit object.}
\usage{
ctCheckFit(fit, niter = 500, probs = c(0.025, 0.5, 0.975))
}
\arguments{
\item{fit}{ctFit or ctStanFit object.}

\item{niter}{number of data generation iterations to use to calculate quantiles.}

\item{probs}{3 digit vector of quantiles to return and to test significance.}
}
\value{
numeric matrix showing Z score difference for each lower triangular index of the covariance matrix of data --
observed covariance minus mean of generated, weighted by sd of generated covariance.
}
\description{
Check absolute fit of ctFit or ctStanFit object.
}
\examples{
\dontrun{
data(ctExample1)
traitmodel <- ctModel(n.manifest=2, n.latent=2, Tpoints=6, LAMBDA=diag(2), 
  manifestNames=c('LeisureTime', 'Happiness'), 
  latentNames=c('LeisureTime', 'Happiness'), TRAITVAR="auto")
traitfit <- ctFit(dat=ctExample1, ctmodelobj=traitmodel)

check <- ctCheckFit(traitfit,niter=5)
plot(check)
}
}
