% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ctStanFit.R
\name{summary.ctStanFit}
\alias{summary.ctStanFit}
\title{summary.ctStanFit}
\usage{
\method{summary}{ctStanFit}(
  object,
  timeinterval = 1,
  digits = 3,
  parmatrices = TRUE,
  priorcheck = TRUE,
  residualcov = TRUE,
  ...
)
}
\arguments{
\item{object}{fit object from \code{\link{ctStanFit}}, of class ctStanFit.}

\item{timeinterval}{positive numeric indicating time interval to use for discrete time parameter calculations
reported in summary.}

\item{digits}{integer denoting number of digits to report.}

\item{parmatrices}{if TRUE, also return additional parameter matrices -- can be slow to compute
for large models with many samples.}

\item{priorcheck}{Whether or not to use \code{ctsem:::priorchecking} to compare posterior mean and sd to prior mean and sd.}

\item{residualcov}{Whether or not to show standardised residual covariance. Takes a little longer to compute.}

\item{...}{Additional arguments to pass to \code{ctsem:::priorcheckreport}, such as \code{meanlim}, or \code{sdlim}.}
}
\value{
List containing summary items.
}
\description{
Summarise a ctStanFit object that was fit using \code{\link{ctStanFit}}.
}
\examples{
\donttest{
summary(ctstantestfit)
}
}
