% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctStanKalman.R
\name{ctStanKalman}
\alias{ctStanKalman}
\title{Get Kalman filter estimates from a ctStanFit object}
\usage{
ctStanKalman(
  fit,
  nsamples = NA,
  collapsefunc = NA,
  cores = 2,
  standardisederrors = FALSE,
  subjectpars = FALSE,
  ...
)
}
\arguments{
\item{fit}{fit object from \code{\link{ctStanFit}}.}

\item{nsamples}{either NA (to extract all) or a positive integer from 1 to maximum samples in the fit.}

\item{collapsefunc}{function to apply over samples, such as \code{mean}}

\item{cores}{Integer number of cpu cores to use. Only needed if savescores was set to FALSE when fitting.}

\item{standardisederrors}{If TRUE, computes standardised errors for prior, upd, smooth conditions.}

\item{subjectpars}{if TRUE, state estimates are not returned, instead, predictions of each subjects parameters
are returned, for parameters that had random effects specified.}

\item{...}{additional arguments to collpsefunc.}
}
\value{
list containing Kalman filter elements, each element in array of
iterations, data row, variables. llrow is the log likelihood for each row of data.
}
\description{
Get Kalman filter estimates from a ctStanFit object
}
\examples{
\donttest{
k=ctStanKalman(ctstantestfit,subjectpars=T,collapsefunc=mean)
}
}
