% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctLOO.R
\name{ctLOO}
\alias{ctLOO}
\title{K fold cross validation for ctStanFit objects}
\usage{
ctLOO(
  fit,
  folds = 10,
  cores = 2,
  parallelFolds = TRUE,
  subjectwise = FALSE,
  keepfirstobs = TRUE
)
}
\arguments{
\item{fit}{ctStanfit object}

\item{folds}{Number of cross validation splits to use -- 10 folds implies that the 
model is re-fit 10 times, each time to a data set with 1/10 of the observations randomly removed.}

\item{cores}{Number of processor cores to use.}

\item{parallelFolds}{compute folds in parallel or use cores to finish single folds faster.}

\item{subjectwise}{drop random subjects instead of data rows?}

\item{keepfirstobs}{do not drop first observation (more stable estimates)}
}
\value{
list
}
\description{
K fold cross validation for ctStanFit objects
}
\examples{
\donttest{ 
ctLOO(ctstantestfit)
}
}
