% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctStanPlotPost.R
\name{ctStanPlotPost}
\alias{ctStanPlotPost}
\title{ctStanPlotPost}
\usage{
ctStanPlotPost(
  obj,
  rows = "all",
  npp = 6,
  priorwidth = TRUE,
  smoothness = 1,
  priorsamples = 10000,
  plot = TRUE,
  wait = FALSE,
  ...
)
}
\arguments{
\item{obj}{fit or model object as generated by \code{\link{ctStanFit}},
\code{\link{ctModel}}, or \code{\link{ctStanModel}}.}

\item{rows}{vector of integers denoting which rows of obj$setup$popsetup to plot priors for. 
Character string 'all' plots all rows with parameters to be estimated.}

\item{npp}{Integer number of parameters to show per page.}

\item{priorwidth}{if TRUE, plots will be scaled to show bulk of both the prior 
and posterior distributions. If FALSE, scale is based only on the posterior.}

\item{smoothness}{Positive numeric -- multiplier to modify smoothness of density plots, higher is smoother but
can cause plots to exceed natural boundaries, such as standard deviations below zero.}

\item{priorsamples}{number of samples from prior to use. More is slower.}

\item{plot}{Logical, if FALSE, ggplot objects are returned in a list instead of plotting.}

\item{wait}{If true, user is prompted to continue before plotting next graph.
If false, graphs are plotted one after another without waiting.}

\item{...}{Parameters to pass to ctStanFit. \code{cores = x} will speed things up,
where x is the number of cpu cores to use.}
}
\description{
Plots prior and posterior distributions of model parameters in a ctStanModel or ctStanFit object.
}
\examples{
\donttest{
ctStanPlotPost(ctstantestfit, rows=3:4)
}
}
