% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctStanGenerateFromFit.R
\name{ctStanGenerateFromFit}
\alias{ctStanGenerateFromFit}
\title{Add a \code{$generated} object to ctstanfit object, with random data generated from posterior of ctstanfit object}
\usage{
ctStanGenerateFromFit(
  fit,
  nsamples = 200,
  fullposterior = FALSE,
  verboseErrors = FALSE,
  cores = 2
)
}
\arguments{
\item{fit}{ctstanfit object}

\item{nsamples}{Positive integer specifying number of datasets to generate.}

\item{fullposterior}{Logical indicating whether to sample from the full posterior (original nsamples) or the posterior mean.}

\item{verboseErrors}{if TRUE, print verbose output when errors in generation encountered.}

\item{cores}{Number of cpu cores to use.}
}
\value{
Matrix of generated data -- one dataset per iteration, according to original time and missingness structure.
}
\description{
Add a \code{$generated} object to ctstanfit object, with random data generated from posterior of ctstanfit object
}
\examples{
gen <- ctStanGenerateFromFit(ctstantestfit, nsamples=3,fullposterior=TRUE,cores=1)
plot(gen$generated$Y[3,,2],type='l') #Third random data sample, 2nd manifest var, all time points. 
}
