% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini_index.R
\encoding{UTF-8}
\name{gini_index}
\alias{gini_index}
\title{Computes the gini index of a categorical time series}
\usage{
gini_index(series, categories)
}
\arguments{
\item{series}{A CTS.}

\item{categories}{A vector of type factor containing the corresponding
categories.}
}
\value{
The value of the gini index.
}
\description{
\code{gini_index} returns the value of the gini index for
a categorical time series
}
\details{
Given a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
estimated gini index, \eqn{\widehat{g}=\frac{r}{r-1}(1-\sum_{i=1}^{r}\widehat{p}_i^2)},
where \eqn{\widehat{p}_i} is the natural estimate of the marginal probability of the \eqn{i}th
category, \eqn{i=1, \ldots, r}.
}
\examples{
gi <- gini_index(series = GeneticSequences$data[[1]],
categories = factor(c('a', 'c', 'g', 't'))) # Computing the gini index
# for the first series in dataset GeneticSequences
}
\references{
{

  \insertRef{weiss2008measuring}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
