% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern_histogram.R
\encoding{UTF-8}
\name{pattern_histogram}
\alias{pattern_histogram}
\title{Constructs the pattern histogram associated with a given category of a
categorical time series}
\usage{
pattern_histogram(
  series,
  category,
  plot = TRUE,
  title = paste0("Pattern histogram (", category, ")"),
  ...
)
}
\arguments{
\item{series}{A CTS.}

\item{category}{The selected category.}

\item{plot}{Logical. If \code{plot = TRUE} (default), returns the pattern
histogram. Otherwise, returns the frequencies of cycle lengths associated
with the corresponding category.}

\item{title}{The title of the graph.}

\item{...}{Additional parameters for the function.}
}
\value{
The pattern histogram.
}
\description{
\code{pattern_histogram} constructs the pattern histogram associated with a given category of a
categorical time series.
}
\details{
Constructs the pattern histogram for a specific category of a CTS. This graph
represents the frequencies of the cycles for the corresponding category according
to their length.
}
\examples{
ph <- pattern_histogram(GeneticSequences$data[[1]],
category = 'a') # Constructing the pattern histogram
# for the first CTS in dataset GeneticSequences concerning the category 'a'
cycle_lengths <- pattern_histogram(GeneticSequences$data[[1]],
category = 'a', plot = FALSE) # Obtaining the frequencies of cycle lengths
}
\references{
{

  \insertRef{weiss2008visual}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
