% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_index.R
\name{get_fop}
\alias{get_fop}
\title{Fraction of optimal codons (Fop)}
\usage{
get_fop(cf, op = NULL, codon_table = get_codon_table(), ...)
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by \code{count_codons()}.}

\item{op}{a character vector of optimal codons. Can be determined automatically by running
\code{est_optimal_codons}.}

\item{codon_table}{a table of genetic code derived from \code{get_codon_table} or
\code{create_codon_table}.}

\item{...}{other arguments passed to \code{est_optimal_codons}.}
}
\value{
a named vector of fop values.
}
\description{
\code{get_fop} calculates the fraction of optimal codons (Fop) of each CDS.
}
\examples{
# estimate Fop of yeast genes
cf_all <- count_codons(yeast_cds)
fop <- get_fop(cf_all)
head(fop)
hist(fop)

}
\references{
Ikemura T. 1981. Correlation between the abundance of Escherichia coli transfer RNAs
  and the occurrence of the respective codons in its protein genes: a proposal for a synonymous
  codon choice that is optimal for the E. coli translational system. J Mol Biol 151:389-409.
}
