% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_index.R
\name{get_gc4d}
\alias{get_gc4d}
\title{GC contents at 4-fold degenerate sites}
\usage{
get_gc4d(cf, codon_table = get_codon_table(), level = "subfam")
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by \code{count_codons()}.}

\item{codon_table}{a table of genetic code derived from \code{get_codon_table} or
\code{create_codon_table}.}

\item{level}{"subfam" (default) or "amino_acid". For which level to determine 
GC contents at 4-fold degenerate sites.}
}
\value{
a named vector of GC4d values.
}
\description{
Calculate GC content at synonymous position of codons (using four-fold degenerate sites only).
}
\examples{
# estimate GC4d of yeast genes
cf_all <- count_codons(yeast_cds)
gc4d <- get_gc4d(cf_all)
head(gc4d)
hist(gc4d)

}
