% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{simple_filter}
\alias{simple_filter}
\title{Apply simple percentage filter}
\usage{
simple_filter(curves, percent_threshold)
}
\arguments{
\item{curves}{A cuperdec curve table calculated with
\code{\link{calculate_curve}}.}

\item{percent_threshold}{A database file loaded with
\code{\link{load_database}}.}
}
\value{
A tibble with each row showing each sample and whether it
  passed the specified filter.
}
\description{
Performs the initial decay curve based on percentage of 'target' isolation
source along a rank of most to least abundant taxa for a given sample.
}
\examples{
data(cuperdec_taxatable_ex)
data(cuperdec_database_ex)

taxa_table <- load_taxa_table(cuperdec_taxatable_ex)
iso_database <- load_database(cuperdec_database_ex, target = "oral")

curve_results <- calculate_curve(taxa_table, iso_database)
simple_filter(curve_results, percent_threshold = 50)
}
