% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkArgs.R
\name{checkArgs}
\alias{checkArgs}
\title{Check Arguments Passed to cvCovEst}
\usage{
checkArgs(
  dat,
  estimators,
  estimator_params,
  cv_loss,
  cv_scheme,
  mc_split,
  v_folds,
  center,
  scale,
  parallel
)
}
\arguments{
\item{dat}{A numeric \code{data.frame}, \code{matrix}, or similar object.}

\item{estimators}{A \code{list} of estimator functions to be considered in
the cross-validated estimator selection procedure.}

\item{estimator_params}{A named \code{list} of arguments corresponding to
the hyperparameters of covariance matrix estimators in \code{estimators}.
The name of each list element should match the name of an estimator passed
to \code{estimators}. Each element of the \code{estimator_params} is itself
a named \code{list}, with the names corresponding to a given estimator's
hyperparameter(s). These hyperparameters may be in the form of a single
\code{numeric} or a \code{numeric} vector. If no hyperparameter is needed
for a given estimator, then the estimator need not be listed.}

\item{cv_loss}{A \code{function} indicating the loss function to be used.
This defaults to the Frobenius loss, \code{\link{cvMatrixFrobeniusLoss}()}.
An observation-based version, \code{\link{cvFrobeniusLoss}()}, is also made
available. Additionally, the \code{\link{cvScaledMatrixFrobeniusLoss}(())}
is included for situations in which \code{dat}'s variables are of different
scales.}

\item{cv_scheme}{A \code{character} indicating the cross-validation scheme
to be employed. There are two options: (1) V-fold cross-validation, via
\code{"v_folds"}; and (2) Monte Carlo cross-validation, via \code{"mc"}.
Defaults to Monte Carlo cross-validation.}

\item{mc_split}{A \code{numeric} between 0 and 1 indicating the proportion
of observations to be included in the validation set of each Monte Carlo
cross-validation fold.}

\item{v_folds}{An \code{integer} larger than or equal to 1 indicating the
number of folds to use for cross-validation. The default is 10, regardless
of the choice of cross-validation scheme.}

\item{center}{A \code{logical} indicating whether to center the columns of
\code{dat} to have mean zero.}

\item{scale}{A \code{logical} indicating whether to scale the columns of
\code{dat} to have unit variance.}

\item{parallel}{A \code{logical} option indicating whether to run the main
cross-validation loop with \code{\link[future.apply]{future_lapply}()}. This
is passed directly to \code{\link[origami]{cross_validate}()}.}
}
\value{
Whether all argument conditions are satisfied
}
\description{
\code{checkArgs()} verifies that all arguments
passed to \code{\link{cvCovEst}()} function meet its specifications.
}
\keyword{internal}
