% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_area_list}
\alias{cvd_area_list}
\title{List areas}
\usage{
cvd_area_list(time_period_id = 1, parent_area_id, system_level_id)
}
\arguments{
\item{time_period_id}{integer - specifies time period for which to return areas (compulsory)}

\item{parent_area_id}{integer - specifies the area of which children will be returned (optional)}

\item{system_level_id}{integer - specifies which system levels to return areas for (optional)}
}
\value{
Tibble of area details
}
\description{
Returns all areas for a given time period and parent area or system level.
Only areas which have data for the specified time period will be returned.
}
\details{
Either parent area or system level must be specified:
If parent area is specified, all children areas of that parent will be returned.
If system level is specified, all areas within that system level will be returned.

Parent area takes precedence over system level - if parent area is specified, system level is ignored.

CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Farea}{Area lists}
}
\examples{
# list four PCNs with data available at time period 17
cvd_area_list(time_period_id = 17, system_level_id = 4) |>
  dplyr::select(SystemLevelName, AreaID, AreaCode, AreaName) |>
  dplyr::slice_head(n = 4)
}
\seealso{
\code{\link[=cvd_area_details]{cvd_area_details()}}, \code{\link[=cvd_area_unassigned]{cvd_area_unassigned()}}, \code{\link[=cvd_area_search]{cvd_area_search()}}, \code{\link[=cvd_area_nested_subsystems]{cvd_area_nested_subsystems()}}, \code{\link[=cvd_area_flat_subsystems]{cvd_area_flat_subsystems()}}
}
