library(cvms)
context("summarize_metrics()")

test_that("summarize_metrics() works in simple example", {

  df <- tibble::tibble(
    "a_num_1" = c(0.03, 0.04, 0.2, 0.9, 2, 5, 2, 1,-0.3,-3),
    "a_num_2" = c(1.03, 0.04, 0.7, 0.25, 0.2, 0.5, 0.2, 0.1, 0.3, 0.9),
    "an_int" = c(1, 2, 1, 4, 1, 6, 8, 5, 3, 8),
    "a_char" = LETTERS[1:10],
    "a_fct" = factor(LETTERS[11:20])
  )

  summ <- summarize_metrics(data = df)

  ## Testing 'summ'                                                         ####
  ## Initially generated by xpectr
  # Testing class
  expect_equal(
    class(summ),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    summ[["Measure"]],
    c("Mean", "Median", "SD", "IQR", "Max", "Min", "NAs", "INFs"),
    fixed = TRUE)
  expect_equal(
    summ[["a_num_1"]],
    c(0.787, 0.55, 2.048, 1.7175, 5, -3, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    summ[["a_num_2"]],
    c(0.422, 0.275, 0.34547, 0.45, 1.03, 0.04, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    summ[["an_int"]],
    c(3.9, 3.5, 2.76687, 4.5, 8, 1, 0, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(summ),
    c("Measure", "a_num_1", "a_num_2", "an_int"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(summ),
    c("character", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(summ),
    c("character", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(summ),
    c(8L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(summ)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'summ'                                                ####

})


test_that("summarize_metrics() works with argument combinations", {

  df <- tibble::tibble(
    "a_num_1" = c(0.03, 0.04, 0.2, 0.9, 2, 5, 2, 1,-0.3, NA),
    "a_num_2" = c(1.03, 0.04, 0.7, 0.25, 0.2, 0.5, 0.2, Inf, 0.3, 0.9),
    "an_int" = c(1, 2, 1, 4, 1, 6, 8, 5, 3, NA),
    "a_char" = LETTERS[1:10],
    "a_fct" = factor(LETTERS[11:20])
  )

  # xpectr::gxs_function(
  #   fn = summarize_metrics,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, .data$a_char), NA, list("a" = c(1, 2, 3)), "a", 2),
  #     "cols" = list(
  #       NULL,
  #       c("an_int", "a_num_1"),
  #       c("a_num_1", "a_char"),
  #       NA,
  #       c(NA, NA)
  #     ),
  #     "na.rm" = list(TRUE, FALSE),
  #     "inf.rm" = list(TRUE, FALSE)
  #   )
  # )

  ## Testing 'summarize_metrics'                                              ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing summarize_metrics(data = dplyr::group_by(df, ....
  # Testing side effects
  expect_error(
    xpectr::strip_msg(summarize_metrics(data = dplyr::group_by(df, .data$a_char), cols = NULL, na.rm = TRUE, inf.rm = TRUE)),
    xpectr::strip("1 assertions failed:\n * Currently, 'data' cannot be grouped."),
    fixed = TRUE)

  # Testing summarize_metrics(data = df, cols = NULL, na.r...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(summarize_metrics(data = df, cols = NULL, na.rm = FALSE, inf.rm = TRUE)),
    xpectr::strip("missing values and NaN's not allowed if 'na.rm' is FALSE"),
    fixed = TRUE)

  # Testing summarize_metrics(data = df, cols = NULL, na.r...
  # Assigning output
  output_18109 <- summarize_metrics(data = df, cols = NULL, na.rm = TRUE, inf.rm = FALSE)
  # Testing class
  expect_equal(
    class(output_18109),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18109[["Measure"]],
    c("Mean", "Median", "SD", "IQR", "Max", "Min", "NAs", "INFs"),
    fixed = TRUE)
  expect_equal(
    output_18109[["a_num_1"]],
    c(1.20778, 0.9, 1.65129, 1.96, 5, -0.3, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_18109[["a_num_2"]],
    c(Inf, 0.4, NaN, 0.6375, Inf, 0.04, 0, 1),
    tolerance = 1e-4)
  expect_equal(
    output_18109[["an_int"]],
    c(3.44444, 3, 2.50555, 4, 8, 1, 1, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_18109),
    c("Measure", "a_num_1", "a_num_2", "an_int"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18109),
    c("character", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18109),
    c("character", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18109),
    c(8L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18109)),
    character(0),
    fixed = TRUE)

  # Testing summarize_metrics(data = NA, cols = NULL, na.r...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(summarize_metrics(data = NA, cols = NULL, na.rm = TRUE, inf.rm = TRUE)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'data': Must be of type 'd",
           "ata.frame', not 'logical'.")),
    fixed = TRUE)

  # Testing summarize_metrics(data = list(a = c(1, 2, 3)),...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(summarize_metrics(data = list(a = c(1, 2, 3)), cols = NULL, na.rm = TRUE, inf.rm = TRUE)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'data': Must be of type 'd",
           "ata.frame', not 'list'.")),
    fixed = TRUE)

  # Testing summarize_metrics(data = "a", cols = NULL, na....
  # Testing side effects
  expect_error(
    xpectr::strip_msg(summarize_metrics(data = "a", cols = NULL, na.rm = TRUE, inf.rm = TRUE)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'data': Must be of type 'd",
           "ata.frame', not 'character'.")),
    fixed = TRUE)

  # Testing summarize_metrics(data = 2, cols = NULL, na.rm...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(summarize_metrics(data = 2, cols = NULL, na.rm = TRUE, inf.rm = TRUE)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'data': Must be of type 'd",
           "ata.frame', not 'double'.")),
    fixed = TRUE)

  # Testing summarize_metrics(data = df, cols = c("an_int"...
  # Assigning output
  output_13880 <- summarize_metrics(data = df, cols = c("an_int", "a_num_1"), na.rm = TRUE, inf.rm = TRUE)
  # Testing class
  expect_equal(
    class(output_13880),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13880[["Measure"]],
    c("Mean", "Median", "SD", "IQR", "Max", "Min", "NAs", "INFs"),
    fixed = TRUE)
  expect_equal(
    output_13880[["an_int"]],
    c(3.44444, 3, 2.50555, 4, 8, 1, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_13880[["a_num_1"]],
    c(1.20778, 0.9, 1.65129, 1.96, 5, -0.3, 1, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_13880),
    c("Measure", "an_int", "a_num_1"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13880),
    c("character", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13880),
    c("character", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13880),
    c(8L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13880)),
    character(0),
    fixed = TRUE)

  # Testing summarize_metrics(data = df, cols = c("a_num_1...
  # Assigning output
  output_16851 <- summarize_metrics(data = df, cols = c("a_num_1", "a_char"), na.rm = TRUE, inf.rm = TRUE)
  # Testing class
  expect_equal(
    class(output_16851),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16851[["Measure"]],
    c("Mean", "Median", "SD", "IQR", "Max", "Min", "NAs", "INFs"),
    fixed = TRUE)
  expect_equal(
    output_16851[["a_num_1"]],
    c(1.20778, 0.9, 1.65129, 1.96, 5, -0.3, 1, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_16851),
    c("Measure", "a_num_1"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16851),
    c("character", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16851),
    c("character", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16851),
    c(8L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16851)),
    character(0),
    fixed = TRUE)

  # Testing summarize_metrics(data = df, cols = NA, na.rm ...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(summarize_metrics(data = df, cols = NA, na.rm = TRUE, inf.rm = TRUE)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'cols': Contains missing v",
           "alues (element 1).")),
    fixed = TRUE)

  # Testing summarize_metrics(data = df, cols = c(NA, NA),...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(summarize_metrics(data = df, cols = c(NA, NA), na.rm = TRUE, inf.rm = TRUE)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'cols': Contains missing v",
           "alues (element 1).")),
    fixed = TRUE)

  # Testing summarize_metrics(data = NULL, cols = NULL, na...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(summarize_metrics(data = NULL, cols = NULL, na.rm = TRUE, inf.rm = TRUE)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'data': Must be of type 'd",
           "ata.frame', not 'NULL'.")),
    fixed = TRUE)

  # Testing summarize_metrics(data = df, cols = NULL, na.r...
  # Assigning output
  output_10039 <- summarize_metrics(data = df, cols = NULL, na.rm = TRUE, inf.rm = TRUE)
  # Testing class
  expect_equal(
    class(output_10039),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10039[["Measure"]],
    c("Mean", "Median", "SD", "IQR", "Max", "Min", "NAs", "INFs"),
    fixed = TRUE)
  expect_equal(
    output_10039[["a_num_1"]],
    c(1.20778, 0.9, 1.65129, 1.96, 5, -0.3, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_10039[["a_num_2"]],
    c(0.45778, 0.3, 0.34622, 0.5, 1.03, 0.04, 0, 1),
    tolerance = 1e-4)
  expect_equal(
    output_10039[["an_int"]],
    c(3.44444, 3, 2.50555, 4, 8, 1, 1, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_10039),
    c("Measure", "a_num_1", "a_num_2", "an_int"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10039),
    c("character", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10039),
    c("character", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10039),
    c(8L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10039)),
    character(0),
    fixed = TRUE)

  # Testing summarize_metrics(data = df, cols = NULL, na.r...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(summarize_metrics(data = df, cols = NULL, na.rm = TRUE, inf.rm = NULL)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'inf.rm': Must be of type ",
           "'logical flag', not 'NULL'.")),
    fixed = TRUE)

  # Testing summarize_metrics(data = df, cols = NULL, na.r...
  # Testing side effects
  expect_error(
    xpectr::strip_msg(summarize_metrics(data = df, cols = NULL, na.rm = NULL, inf.rm = TRUE)),
    xpectr::strip(paste0("1 assertions failed:\n * Variable 'na.rm': Must be of type '",
           "logical flag', not 'NULL'.")),
    fixed = TRUE)

  ## Finished testing 'summarize_metrics'                                     ####



})
