% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvt_approach.R
\name{celldebris_emclustering}
\alias{celldebris_emclustering}
\title{identifies BS4, BS5 and Debris in a flowfile using an EM style algorithm.}
\usage{
celldebris_emclustering(flowfile, channels, mu = NULL, sigma = NULL,
  ncluster = 5, min.itera = 20)
}
\arguments{
\item{flowfile}{flowframe to be clustered.}

\item{channels}{channels to use for the clustering}

\item{mu}{pre-specified mean matrix for the clusters. Number of rows should equal ncluster and number
of columns should equal length(channels). Defaults to NULL and will be computed from the data internally if left as NULL.}

\item{sigma}{pre-specified list of variance-covariace matrix for the clusters. Each element of the list should contain a square matrix
of variance-covariance matrix with length equal ncluster. Defaults to NULL and will be computed from the data internally if left as NULL.}

\item{ncluster}{number of cluster desired.}

\item{min.itera}{minimum number of EM iterations.}
}
\value{
list containing; \itemize{
\item \strong{percentages -} percentage of cells in each cluster
\item \strong{mus -} matrix of mean vectors for each cluster
\item \strong{sigmas -} list of variance-covariance matrix for each cluster
\item \strong{result -} flowframe with probabilities of each cluster added as columns to the expression matrix of the flowfile
}
}
\description{
separates BS4, BS5 and Debris population in a flowfile using an EM style algorithm.
             Algorithm starts with \emph{ncluster} number of clusters and automatically reduces
             this number if need be.
}
\details{
The function using EM algorithm involving mixtures of multivariate normals to separate the entire cell-population provided into cluster. The \code{\link{mvnorm}}
         function is used to compute the densities and only the probabilites of each point belonging to a cluster are returned as additional columns to the
         expression matrix of \emph{result}.
}
\examples{
\donttest{
flowfile_path <- system.file("extdata", "text.fcs", package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) #FCS file contains only one data object
flowfile_nona <- cyanoFilter::nona(x = flowfile)
flowfile_noneg <- cyanoFilter::noneg(x = flowfile_nona)
flowfile_logtrans <- lnTrans(x = flowfile_noneg, c('SSC.W', 'TIME'))
cells_nonmargin <- cellmargin(flow.frame = flowfile_logtrans, Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")

emapproach <- cyano_emclustering(flowfile = cells_nonmargin, channels = c("RED.B.HLin",
                   "YEL.B.HLin", "FSC.HLin", "RED.R.HLin"),
                   ncluster = 5, min.itera = 20)
}


}
\seealso{
\code{\link{celldebris_nc}}
}
