% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_gating.R
\name{celldebris_nc}
\alias{celldebris_nc}
\title{gates out or assign indicators to Synechococcus cyanobacteria cells.}
\usage{
celldebris_nc(flowframe, channel1 = "RED.B.HLin",
  channel2 = "YEL.B.HLin", interest = c("bottom-right", "top-right",
  "both-right"), to_retain = c("refined", "potential"))
}
\arguments{
\item{flowframe}{flowframe with debris and Synechococcus cells.}

\item{channel1}{first flowcytometer channel that can be used to separate cyanobacteria
cells from the rest, e.g. "RED.B.HLin".}

\item{channel2}{second flowcytometer channel that can be used to separate cyanobacteria
cells from the rest, e.g. "YEL.B.HLin"}

\item{interest}{a string indicating poistion of population of interest to be gated,
can be "bottom-right", "top-right" or "both-right".}

\item{to_retain}{should potential candidates be retained or further
gating be applied to filter out only certain cyano cells.}
}
\value{
list containing; \itemize{
\item \strong{fullframe -} full flowframe with indicator for debris, BS4/BS5 or both.
\item \strong{reducedframe -} flowframe with onlySynechococcus cyanobacteria.
\item \item \strong{Cell_count -} a vector containing number of Synechococcus cyanobacteria
                                  cells. Might be a single value or vector of two values
                                  depending on interest.
\item \strong{Debris_count -} number of debris particles.
}
}
\description{
This is a top-level function that calls other functions to identify cell population of interest.
}
\details{
The indicators assigned to the "BS4BS5.Indicator" column in the full flowframe depends
         on the \emph{interest} supplied. For \emph{interest="bottom-right"} or
         \emph{interest="top-right"}; 0 = Debris, 1 = BS4/BS5, 2 = not-identified while for
         \emph{interest="Both"}, 0 = Debris, 1 = Syn-1, 2 = Syn-2, 3 = not-identified.
         This function calls the \code{\link{debris_nc}} or \code{\link{debris_inc}} function to
         identify debris and afterwards call the \code{\link{bs4_nc}} and/or \code{\link{bs5_nc}}
         depending on the interest supplied.
}
\examples{
\donttest{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) #FCS file contains only one data object
flowfile_nona <- cyanoFilter::nona(x = flowfile)
flowfile_noneg <- cyanoFilter::noneg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, c('SSC.W', 'TIME'))
cells_nonmargin <- cellmargin(flow.frame = flowfile_logtrans, Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")
celldebris_nc(flowframe = cells_nonmargin$reducedframe, channel1 = "RED.B.HLin",
              channel2 = "YEL.B.HLin",
              interest = "bottom-right", to_retain = "refined")
}

}
\seealso{
\code{\link{celldebris_emclustering}}
}
