% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_subpopulations.R
\name{extract_subpopulations}
\alias{extract_subpopulations}
\title{Extract subpopulations.}
\usage{
extract_subpopulations(population, reference, variables, k)
}
\arguments{
\item{population}{tbl with grouping (metadata) and observation variables.}

\item{reference}{tbl with grouping (metadata) and observation variables. Columns of \code{population} and \code{reference} should be identical.}

\item{variables}{character vector specifying observation variables.}

\item{k}{scalar specifying number of clusters.}
}
\value{
list containing clusters centers (\code{subpop_centers}), two
normalized histograms specifying frequency of each clusters in population
and reference (\code{subpop_profiles}), and cluster prediction and distance to
the predicted cluster for all input data (\code{population_clusters} and
\code{reference_clusters}).
}
\description{
\code{extract_subpopulations} identifies clusters in the reference and
population sets and reports the frequency of points in each cluster for the
two sets.
}
\examples{
data <- tibble::tibble(
  Metadata_group = c(
    "control", "control", "control", "control",
    "experiment", "experiment", "experiment", "experiment"
  ),
  AreaShape_Area = c(10, 12, NA, 16, 8, 8, 7, 7),
  AreaShape_Length = c(2, 3, NA, NA, 4, 5, 1, 5)
)
variables <- c("AreaShape_Area", "AreaShape_Length")
population <- dplyr::filter(data, Metadata_group == "experiment")
reference <- dplyr::filter(data, Metadata_group == "control")
extract_subpopulations(
  population = population,
  reference = reference,
  variables = variables,
  k = 3
)
}
